


export class ActivityPopup {
	
	tpl = `
		<div class="page-header">
			<div class="toolbox">
				<a href="javascript:void(0)" [onclick]="widget.close" class="fa fa-times-circle"></a>
			</div>
			<h1>Logboek item {{ activity ? '#' + activity.activityId : '' }}</h1>
		</div>

		<div ez-if="activity == null">
			Loading...
		</div>
		<div ez-if="activity != null">
			
			<table class="table">
				<tr>
					<th style="width: 300px;">Tijdstip</th>
					<td>{{format_datetime(activity.created)}}</td>
				</tr>
				<tr>
					<th>Description</th>
					<td>{{activity.shortDescription}}</td>
				</tr>
				<tr>
					<th>User</th>
					<td>{{activity.username}}</td>
				</tr>
				<tr>
					<th>Customer #</th>
					<td>{{activity.customerId}}</td>
				</tr>
				<tr>
					<th>Ref. Object</th>
					<td>{{activity.refObject}}</td>
				</tr>
				<tr>
					<th>Ref. Id</th>
					<td>{{activity.refId}}</td>
				</tr>
				<tr ez-if="activity.subRefObject != null">
					<th>Sub Object/Id</th>
					<td>
						{{ activity.subRefObject }}
						/ 
						{{ activity.subRefId }}
					</td>
				</tr>
				<tr>
					<th>Code</th>
					<td>{{activity.code}}</td>
				</tr>
			</table>
			
			<div ez-if="activity.values && activity.values.length > 0">
				
				<hr/>
				
				<table class="table">
					<thead>
						<tr>
							<th style="width: 300px;">Veld</th>
							<th>Oude waarde</th>
							<th>Nieuwe </th>
						</tr>
					</thead>
					<tbody ez-for="activity.values" ez-item="av">
						<tr>
							<td>{{ activityFieldName(av.refField) }}</td>
							<td>{{av.oldValue ?? ''}}</td>
							<td>{{av.newValue ?? ''}}</td>
						</tr>
					</tbody>
				</table>
			</div>
			
		</div>
	`;
	
	isNew = true;
	
	container = null;
	activity = null;
	activityId = null;
	
	constructor( activityId ) {
		this.activityId = activityId;
	}
	
	
	close() {
		close_popup();
	}
	
	loadActivity( activityId ) {
		console.log('loading...');
		postUrl( '/service/activity.do', {
			a: 'view',
			activityId: activityId
		}).then( async function(e) {
			let json = await e.json();
			this.activity = json.activity;
			this.render();
		}.bind(this) );
		
	}
	
	render() {
		let ezTpl = new EzTemplate( this.container );
		ezTpl.loadHtml( this.tpl );
		ezTpl.setObject('widget', this);
		ezTpl.setVar('activity', this.activity);
		ezTpl.render();
	}
	
	
	showPopup() {
		this.container = show_popup('Logboek item', '');
		
		this.render();
		
		this.loadActivity( this.activityId );
	}
	
}

